const { CopyAndPaste, QrCodeImage } = require('pixjs');
const express = require('express');
const cors = require('cors');
const app = express();

// Configurar middleware
app.use(cors());
app.use(express.json());

// Rota para gerar código PIX
app.post('/generate_pix', (req, res) => {
    try {
        const { pixKey, amount, description } = req.body;

        // Validar dados
        if (!pixKey) {
            throw new Error('Chave PIX é obrigatória');
        }

        if (!amount || amount <= 0) {
            throw new Error('Valor deve ser maior que zero');
        }

        // Configurar dados do merchant
        const merchantName = "MATEUS SHOP".replace(/[^A-Za-z0-9 ]/g, '').toUpperCase();
        const merchantCity = "SAO PAULO".replace(/[^A-Za-z0-9 ]/g, '').toUpperCase();
        
        // Gerar código PIX
        const pixData = CopyAndPaste({
            name: merchantName.substring(0, 25),
            key: pixKey.trim(),
            amount: parseFloat(amount),
            city: merchantCity.substring(0, 15),
            id: description ? description.substring(0, 25) : 'PAGAMENTO'
        });

        // Gerar QR Code
        const qrCodeData = QrCodeImage({
            name: merchantName.substring(0, 25),
            key: pixKey.trim(),
            amount: parseFloat(amount),
            city: merchantCity.substring(0, 15),
            id: description ? description.substring(0, 25) : 'PAGAMENTO',
            path: 'qrcodes/'
        });

        // Retornar sucesso
        res.json({
            success: true,
            pixCode: pixData.payload,
            qrCodePath: qrCodeData.path
        });

    } catch (error) {
        console.error('Erro ao gerar PIX:', error);
        res.status(500).json({
            success: false,
            error: 'Erro ao gerar código PIX: ' + error.message
        });
    }
});

// Servir arquivos estáticos (QR codes)
app.use('/qrcodes', express.static('qrcodes'));

// Iniciar servidor
const PORT = process.env.PORT || 3000;
app.listen(PORT, () => {
    console.log(`Servidor rodando na porta ${PORT}`);
}); 