<?php
header('Content-Type: application/json');

// Receber dados do POST
$data = json_decode(file_get_contents('php://input'), true);
$chave = $data['chave'] ?? '';
$valor = $data['valor'] ?? 0;

// Função para gerar o código PIX (exemplo simplificado)
function gerarCodigoPix($chave, $valor) {
    // Aqui você pode implementar a lógica real de geração do código PIX
    // Este é apenas um exemplo
    return "00020126330014BR.GOV.BCB.PIX0111{$chave}520400005303986540{$valor}5802BR5913PIX Pagamento6008SAOPAULO62070503***6304";
}

// Função para gerar URL do QR Code usando image-charts.com
function gerarQRCodeUrl($codigoPix) {
    $qrCodeUrl = "https://image-charts.com/chart?chs=500x500&cht=qr&chl=" . urlencode($codigoPix);
    return $qrCodeUrl;
}

if ($chave && $valor) {
    $codigoPix = gerarCodigoPix($chave, number_format($valor, 2, '.', ''));
    $qrCodeUrl = gerarQRCodeUrl($codigoPix);
    
    echo json_encode([
        'success' => true,
        'pixCode' => $codigoPix,
        'qrCodeUrl' => $qrCodeUrl
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Dados inválidos'
    ]);
}
?> 